
<?php
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/../utils.php';
require_login();

$err=''; $ok='';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $Nomor_Surat = trim($_POST['Nomor_Surat'] ?? '');
  $Tanggal_surat = $_POST['Tanggal_surat'] ?? '';
  $tanggal_terima = $_POST['tanggal_terima'] ?? '';
  $Asal_surat = trim($_POST['Asal_surat'] ?? '');
  $perihal = trim($_POST['perihal'] ?? '');
  $penerima = trim($_POST['penerima'] ?? '');

  list($okUpload, $fileUrlOrErr) = move_uploaded_to_baseurl('file_surat');
  if (!$okUpload) { $err = $fileUrlOrErr; }
  else {
    $st = db()->prepare("INSERT INTO surat_masuk (Nomor_Surat, Tanggal_surat, tanggal_terima, Asal_surat, perihal, file_surat, penerima) VALUES (?,?,?,?,?,?,?)");
    $st->execute([$Nomor_Surat, $Tanggal_surat, $tanggal_terima, $Asal_surat, $perihal, $fileUrlOrErr, $penerima]);
    header('Location: ' . BASE_URL . '/surat_masuk_list.php?ok=1');
    exit;
  }
}
?>
<?php include __DIR__ . '/partials_header.php'; ?>

<h2 class="text-xl font-semibold text-slate-800 mb-4">Tambah Surat Masuk</h2>
<?php if ($err): ?><div class="mb-4 text-sm text-red-700 bg-red-50 border border-red-200 rounded-lg p-3"><?= h($err) ?></div><?php endif; ?>
<form method="post" enctype="multipart/form-data" class="bg-white rounded-2xl shadow p-6 grid md:grid-cols-2 gap-4">
  <div>
    <label class="block text-sm font-medium mb-1">Nomor Surat</label>
    <input name="Nomor_Surat" class="w-full border rounded-lg px-3 py-2" required>
  </div>
  <div>
    <label class="block text-sm font-medium mb-1">Tanggal Surat</label>
    <input type="date" name="Tanggal_surat" class="w-full border rounded-lg px-3 py-2" required>
  </div>
  <div>
    <label class="block text-sm font-medium mb-1">Tanggal Terima</label>
    <input type="date" name="tanggal_terima" class="w-full border rounded-lg px-3 py-2" required>
  </div>
  <div>
    <label class="block text-sm font-medium mb-1">Asal Surat</label>
    <input name="Asal_surat" class="w-full border rounded-lg px-3 py-2" required>
  </div>
  <div class="md:col-span-2">
    <label class="block text-sm font-medium mb-1">Perihal</label>
    <textarea name="perihal" class="w-full border rounded-lg px-3 py-2" rows="3" required></textarea>
  </div>
  <div>
    <label class="block text-sm font-medium mb-1">Penerima</label>
    <input name="penerima" class="w-full border rounded-lg px-3 py-2" required>
  </div>
  <div>
    <label class="block text-sm font-medium mb-1">File Surat (PDF/DOC/DOCX/JPG)</label>
    <input type="file" name="file_surat" accept=".pdf,.doc,.docx,.jpg,.jpeg,.png" class="w-full" required>
  </div>
  <div class="md:col-span-2 flex gap-3">
    <button class="bg-indigo-600 text-white px-4 py-2 rounded-lg">Simpan</button>
    <a href="<?= BASE_URL ?>/surat_masuk_list.php" class="px-4 py-2 rounded-lg border">Batal</a>
  </div>
</form>

<?php include __DIR__ . '/partials_footer.php'; ?>
