
<?php
require_once __DIR__ . '/../auth.php';

if (current_user()) {
  header('Location: ' . BASE_URL . '/dashboard.php');
  exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = $_POST['password'] ?? '';
  if (login($u, $p)) {
    header('Location: ' . BASE_URL . '/dashboard.php');
    exit;
  }
  $error = 'Username atau password salah.';
}
?>
<!doctype html>
<html lang="id">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Login | Persuratan</title>
    <script src="https://cdn.tailwindcss.com"></script>
  </head>
  <body class="min-h-screen bg-gradient-to-b from-indigo-50 to-white flex items-center justify-center p-4">
    <div class="w-full max-w-md bg-white shadow-xl rounded-2xl p-6">
      <div class="text-center mb-6">
        <h1 class="text-2xl font-bold text-slate-800">Masuk ke Persuratan</h1>
        <p class="text-slate-500 text-sm">Silakan login menggunakan akun yang telah terdaftar.</p>
      </div>
      <?php if ($error): ?>
        <div class="mb-4 text-sm text-red-700 bg-red-50 border border-red-200 rounded-lg p-3"><?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
      <form method="post" class="space-y-4">
        <div>
          <label class="block text-sm font-medium text-slate-700 mb-1">Username</label>
          <input type="text" name="username" class="w-full border rounded-lg px-3 py-2 focus:outline-none focus:ring focus:border-indigo-400" required>
        </div>
        <div>
          <label class="block text-sm font-medium text-slate-700 mb-1">Password</label>
          <input type="password" name="password" class="w-full border rounded-lg px-3 py-2 focus:outline-none focus:ring focus:border-indigo-400" required>
        </div>
        <button class="w-full bg-indigo-600 text-white py-2 rounded-lg hover:bg-indigo-700">Login</button>
      </form>
      <p class="mt-6 text-xs text-slate-500 text-center">
        Hint: gunakan data pada tabel <code>user</code> dari database Anda.
      </p>
    </div>
  </body>
</html>
